﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace ErrorExample
{
    class Program
    {
        // Listing 6-10. Obsługa błędu.
        static void Main(string[] args)
        {
            Turtle arthurTheTurtle =
                new Turtle
                {
                    PlatformWidth = 0.0,
                    PlatformHeight = 10.0,
                    MotorSpeed = 5.0
                };

            ShowPosition(arthurTheTurtle);

            // Chcemy jechać prosto...
            arthurTheTurtle.LeftMotorState = MotorState.Running;
            arthurTheTurtle.RightMotorState = MotorState.Running;
            // ...przez dwie sekundy
            TurtleError result = arthurTheTurtle.RunFor(2.0);

            if (result != TurtleError.OK)
            {
                HandleError(result);
                return;
            }

            ShowPosition(arthurTheTurtle);

            // A teraz obrócimy trochę robota zgodnie z ruchem wskazówek zegara.
            arthurTheTurtle.RightMotorState = MotorState.Reversed;
            // Pi/2 sekundy powinno wystarczyć.
            result = arthurTheTurtle.RunFor(Math.PI / 2.0);
            if (result != TurtleError.OK)
            {
                HandleError(result);
                return;
            }

            ShowPosition(arthurTheTurtle);

            // A teraz jedziemy do tyłu...
            arthurTheTurtle.RightMotorState = MotorState.Reversed;
            arthurTheTurtle.LeftMotorState = MotorState.Reversed;

            // ...przez pięć sekund..
            result = arthurTheTurtle.RunFor(5);
            if (result != TurtleError.OK)
            {
                HandleError(result);
                return;
            }

            ShowPosition(arthurTheTurtle);

            // ...po czym obracamy się w przeciwnym kierunku...
            arthurTheTurtle.RightMotorState = MotorState.Running;
            // ...przez pi/4 sekundy, co da nam 45 stopni
            result = arthurTheTurtle.RunFor(Math.PI / 4.0);
            if (result != TurtleError.OK)
            {
                HandleError(result);
                return;
            }

            ShowPosition(arthurTheTurtle);

            // I znowu pojedziemy trochę do tyłu.
            arthurTheTurtle.RightMotorState = MotorState.Reversed;
            arthurTheTurtle.LeftMotorState = MotorState.Reversed;
            result = arthurTheTurtle.RunFor(Math.Cos(Math.PI / 4.0));
            if (result != TurtleError.OK)
            {
                HandleError(result);
                return;
            }

            ShowPosition(arthurTheTurtle);

            Console.ReadKey();
        }
         
        private static void HandleError(TurtleError result) 
        { 
            Console.WriteLine("Robot zgłosił błąd {0}", result); 
            Console.ReadKey(); 
        } 
         
        private static void ShowPosition(Turtle arthurTheTurtle)
        {
            Console.WriteLine(
            "Artur znajduje się w miejscu ({0}) i jest obrócony w kierunku {1:0.00} radianów.",
            arthurTheTurtle.CurrentPosition,
            arthurTheTurtle.CurrentOrientation);
        }
    }
}
